/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.core.util.SourcePrinter;
import com.aptana.json.IState;
import com.aptana.json.Schema;

public class SchemaProperty {
    private Schema _owningSchema;
    private String _name;
    private String _typeName;
    private String _description;
    private String _example;
    private boolean _optional;
    private Object _value;

    SchemaProperty(Schema owningSchema) {
        this(owningSchema, null, null);
    }

    SchemaProperty(Schema owningSchema, String name, String typeName) {
        this._owningSchema = owningSchema;
        this._name = name;
        this._typeName = typeName;
    }

    public String getDescription() {
        return this._description;
    }

    public String getExample() {
        return this._example;
    }

    public String getName() {
        return this._name;
    }

    public Schema getOwningSchema() {
        return this._owningSchema;
    }

    public IState getType() {
        return this._owningSchema.getType(this._typeName);
    }

    public String getTypeName() {
        return this._typeName;
    }

    public Object getValue() {
        return this._value;
    }

    public boolean isOptional() {
        return this._optional;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOptional(boolean optional) {
        this._optional = optional;
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String toSource() {
        SourcePrinter writer = new SourcePrinter();
        this.toSource(writer);
        return writer.toString();
    }

    public void toSource(SourcePrinter writer) {
        writer.printWithIndent(this.getName()).print(" : ").print(this.getTypeName());
        if (this._value != null) {
            writer.print(" := ").print(this._value);
        }
        writer.println();
    }
}

